{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 11.01.99 - 17:17:43 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMObj, MMDIBCv, MMLevel, MMConect, MMHook, MMDesign, MMDSPObj,
  MMUtils, MMWavOut, MMAudio, MMSlider, ExtCtrls, MMWave, MMACMCvt,
  MMMPEG, MMPitch;

type
  TForm1 = class(TForm)
    WaveOut: TMMWaveOut;
    MMDesigner1: TMMDesigner;
    OpenDialog: TOpenDialog;
    MMConnector1: TMMConnector;
    MMLevel1: TMMLevel;
    MMLevel2: TMMLevel;
    btnPlay: TButton;
    btnStop: TButton;
    btnFade: TButton;
    Slider: TMMSlider;
    Timer1: TTimer;
    AudioFile: TMMAudioFile;
    Pitch: TMMPitch;
    Label1: TLabel;
    Slider2: TMMSlider;
    Label2: TLabel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnPlayClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure WaveOutStop(Sender: TObject);
    procedure WaveOutStart(Sender: TObject);
    procedure btnFadeClick(Sender: TObject);
    procedure SliderTrack(Sender: TObject);
    procedure SliderTrackEnd(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure SliderChange(Sender: TObject);
    procedure Slider2Change(Sender: TObject);
  private
    Seeking: Boolean;
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{------------------------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   WaveOut.Close;
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveOutStart(Sender: TObject);
begin
   btnPlay.Enabled := False;
   btnStop.Enabled := True;
   btnFade.Enabled := True;
   Slider.Enabled  := True;
   Timer1.Enabled := True;
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveOutStop(Sender: TObject);
begin
   WaveOut.Close;
   btnPlay.Enabled := True;
   btnStop.Enabled := False;
   btnFade.Enabled := False;
   Timer1.Enabled := False;
//   Slider.Position := 0;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnPlayClick(Sender: TObject);
begin
   if (AudioFile.FileName = '') and OpenDialog.Execute then
   begin
      AudioFile.FileName := OpenDialog.FileName;
      // here you can set also fade params
      //AudioFile.FadeInDuration := 2000;
      //AudioFile.FadeOutDuration:= 2000;
      //AudioFile.FadeOutPosition:= AudioFile.FileLength-AudioFile.FadeOutDuration;
      Slider.MaxValue := AudioFile.PlayLength;
      WaveOut.Start;
   end
   else if not AudioFile.Empty then
   begin
      AudioFile.Position := Slider.Position;
      WaveOut.Start;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnStopClick(Sender: TObject);
begin
   WaveOut.Stop;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnFadeClick(Sender: TObject);
begin
   AudioFile.FadeOut(5000);
end;

{------------------------------------------------------------------------------}
procedure TForm1.SliderTrack(Sender: TObject);
begin
   Seeking := True;
end;

{------------------------------------------------------------------------------}
procedure TForm1.SliderTrackEnd(Sender: TObject);
begin
   if (wosOpen in WaveOut.State) then
   begin
      WaveOut.Pause;
      AudioFile.Position   := Slider.Position;
      WaveOut.Reset;
      WaveOut.Restart;
   end;
   Seeking := False;
end;

{------------------------------------------------------------------------------}
procedure TForm1.Timer1Timer(Sender: TObject);
begin
   if not Seeking then
      Slider.Position := AudioFile.Position;
end;

procedure TForm1.SliderChange(Sender: TObject);
begin

end;

{------------------------------------------------------------------------------}
procedure TForm1.Slider2Change(Sender: TObject);
begin
   Pitch.Pitch := Slider2.Position;
end;

end.


